#include <PinChangeInterrupt.h>

/*
 * Define pins used to provide RC PWM signal to Arduino
 * Pins 8, 9 and 10 are used since they work on both ATMega328 and 
 * ATMega32u4 board. So this code will work on Uno/Mini/Nano/Micro/Leonardo
 * See PinChangeInterrupt documentation for usable pins on other boards
 */
const byte channel_pin[] = {8, 9, 10};
volatile unsigned long rising_start[] = {0, 0, 0};
volatile long channel_length[] = {0, 0, 0};

#define led_r 7
#define led_j 6
#define led_v 5
#define led_b 4

int etat;

void setup() {
  Serial.begin(57600);

  pinMode(channel_pin[0], INPUT);
  pinMode(channel_pin[1], INPUT);
  pinMode(channel_pin[2], INPUT);

  pinMode(led_r, OUTPUT);  
  pinMode(led_j, OUTPUT);
  pinMode(led_v, OUTPUT);
  pinMode(led_b, OUTPUT);

  attachPinChangeInterrupt(digitalPinToPinChangeInterrupt(channel_pin[0]), onRising0, CHANGE);
  attachPinChangeInterrupt(digitalPinToPinChangeInterrupt(channel_pin[1]), onRising1, CHANGE);
  attachPinChangeInterrupt(digitalPinToPinChangeInterrupt(channel_pin[2]), onRising2, CHANGE);

  digitalWrite(led_r, HIGH);
  digitalWrite(led_j, HIGH);
  digitalWrite(led_v, HIGH);
  digitalWrite(led_b, HIGH);
  delay(1000);
  digitalWrite(led_r, LOW);
  digitalWrite(led_j, LOW);
  digitalWrite(led_v, LOW);
  digitalWrite(led_b, LOW);
  delay(1000);
  digitalWrite(led_r, HIGH);
  digitalWrite(led_j, HIGH);
  digitalWrite(led_v, HIGH);
  digitalWrite(led_b, HIGH);
  delay(1000);
  digitalWrite(led_r, LOW);
  digitalWrite(led_j, LOW);
  digitalWrite(led_v, LOW);
  digitalWrite(led_b, LOW);
}

void processPin(byte pin) {
  uint8_t trigger = getPinChangeInterruptTrigger(digitalPinToPCINT(channel_pin[pin]));

  if(trigger == RISING) {
    rising_start[pin] = micros();
  } else if(trigger == FALLING) {
    channel_length[pin] = micros() - rising_start[pin];
  }
}

void onRising0(void) {
  processPin(0);
}

void onRising1(void) {
  processPin(1);
}

void onRising2(void) {
  processPin(2);
}

void loop() {
  
  Serial.print(channel_length[0]);
  etat=map(channel_length[0], 0, 1000, 1, 5);
  Serial.print(" | ");
  Serial.print(etat);
  Serial.print(" | ");
  Serial.print(channel_length[1]);
  Serial.print(" | ");
  Serial.print(channel_length[2]);
  
  Serial.println("");
  
    switch (etat) {
    case 1:
    digitalWrite(led_r, HIGH);
    digitalWrite(led_j, LOW);
    digitalWrite(led_v, LOW);
    digitalWrite(led_b, LOW);
    break;
    case 2:
    digitalWrite(led_r, LOW);
    digitalWrite(led_j, HIGH);
    digitalWrite(led_v, LOW);
    digitalWrite(led_b, LOW);
    break;
    case 3:
    digitalWrite(led_r, LOW);
    digitalWrite(led_j, LOW);
    digitalWrite(led_v, HIGH);
    digitalWrite(led_b, LOW);
    break;
    case 4:
    digitalWrite(led_r, LOW);
    digitalWrite(led_j, LOW);
    digitalWrite(led_v, LOW);
    digitalWrite(led_b, HIGH);
    break;
   }
}
